﻿using System;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;

public partial class DataExportBioInterpretation : Page
{
    private UserAccountManager _currentUser;
    
    protected void Page_Load(object sender, EventArgs e)
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;

        // Check whether the user has EFR TEFSC COORDINATOR role
        if (_currentUser.GetRoles().Contains(4))
        {
            Response.ClearContent();
            Response.AddHeader("content-disposition", "attachment; filename=DataExport.xls");
            Response.ContentType = "application/vnd.ms-excel";
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //Some text values will mistakenly interpreted as numeric by Excel, such as postal codes and social security numbers
        //Such fields may loose their trailing zeros, such as zip code "00700" converts into number 700
        //Use the code below to explicitely convert affected columns into text format
        //Column numbers start with 0
        
        if (e.Row.RowType == DataControlRowType.DataRow) 
        {
            //MJ, 01/25/2011, Cells values are referenced by ColumnName instead of column Index
            GetCellByBoundFieldName(e.Row, "SSN").Attributes.Add("class", "text");
            GetCellByBoundFieldName(e.Row, "TEFSC_REFERENCE_RANGE").Attributes.Add("class", "text");
            

            //GetCellByBoundFieldName(e.Row, "POSTAL_CODE").Attributes.Add("class", "text");
            //GetCellByBoundFieldName(e.Row, "ZIP_PLUS_4").Attributes.Add("class", "text");
            //GetCellByBoundFieldName(e.Row, "REFERRAL_VAMC_NUMBER").Attributes.Add("class", "text");

         } 
    }

    public override void VerifyRenderingInServerForm(Control control)
    {
    }

    DataControlFieldCell GetCellByBoundFieldName(GridViewRow row, string fieldName)
    {
        foreach (DataControlFieldCell cell in row.Cells)
        {
            BoundField bf = cell.ContainingField as BoundField;
            if (bf != null)
            {
                if (bf.DataField == fieldName)
                {
                    return cell;
                }
            }
        }
        return null;
    }

    protected void SqlDataSource1_Selecting(object sender, SqlDataSourceCommandEventArgs e)
    {
        e.Command.CommandTimeout = Helpers.GetTimeoutValue();
    }
}
